bl_info = {
    "name": "Streamline Modding Tool",
    "blender": (2, 80, 0),  # Minimum Blender version required
    "category": "Mesh",
    "location": "View3D > Tool Shelf > 2K Streamline",
    "description": "A collection of mesh editing tools for modding.",
    "author": "ProWrestlingMods",
    "version": (1, 0, 3),
    "wiki_url": "https://wiki.prowrestlingmods.io",
    "tracker_url": "",
}

if "bpy" in locals():
    import importlib
    if "streamline_tools" in locals():
        importlib.reload(streamline_tools)

else:
    from . import streamline_tools

def register():
    streamline_tools.register()

def unregister():
    streamline_tools.unregister()

if __name__ == "__main__":
    register()
